#-----------用户修改------------
#请用户修改下方id，字数至少大于8位，防止与他人重复
#端口port，1至65535
#说明，如果无法更新ID，请换个ID，如需删除后台，请登录http://www.ipv6t.online/，查询ID后，有删除选项
#requests，json需要安装依赖，如已安装，可忽略


id = '12345abcda'
port = '90'

#用户链接参考 http://www.ipv6t.online:90/id.php?id=12345abcda
#----------用户修改截止-----------



import requests
import json
import uuid
from time import sleep

MAC=uuid.uuid1().hex[-12:]
guistatus=''
def decode_unicode_escape(text):
    import re
    def replace(match):
        return chr(int(match.group(1), 16))
    # 使用正则表达式找到所有的\uXXXX序列，并替换为对应的Unicode字符
    decoded_text = re.sub(r'\\u([0-9A-Fa-f]{4})', replace, text)
    return decoded_text


def send_post_request(phptype, ipv6, id,port,url,sign,MAC):
    url = url
    data = {
        'type': phptype,
        'ipv6': ipv6,
        'id': id,
        'port':port,
        'sign':sign,
        'MAC':MAC
    }
    headers = {
        'Content-Type': 'application/x-www-form-urlencoded'
    }
    try:
        # 发送POST请求
        response = requests.post(url, data=data, headers=headers, timeout=5)  # 设置超时时间为5秒
        # 检查响应状态码
        if response.status_code == 200:
            result = response.text
            decoded_string = decode_unicode_escape(result)  # 假设这个函数是定义好的
            # 您可以根据需要在这里处理返回的数据
            if result == '0结果':
                print("No results found.")
                return (True, {})
            else:
                print("Results found,服务器后台连接成功")
                jsondata = json.loads(decoded_string)
                jsondata0 = jsondata[0] if jsondata else {}
                return (True, jsondata0)
        else:
            print(f"Request failed with status code {response.status_code}.")
            return (False, [])
    except requests.RequestException as e:
        print(f"An error occurred: {e}")
        return (False, [])




def main():
    ## 如果需要循环执行，取消while(True)，sleep(600)，注释
    # while(True):
    #     sleep(600)#10分钟更新一次
    ## 如果需要循环执行，取消while(True)，sleep(600)，注释

        ipv6url='http://www.ipv6t.online:90/ipv6.php'#获取本机IPV6地址
        phptype='update'#更新后台数据标签
        ipv6=''
        sign=1#数据类别，不要修改
        guistatus, datajson =send_post_request(phptype, ipv6, id,port,ipv6url,sign,MAC)
        print('IPV6查询返回数据：',guistatus, datajson)
        print('IPV6:',datajson['ipv6'])


        if guistatus and datajson['ipv6']:
            print('开始更新服务器后台')
            ipv6 =datajson['ipv6']
            url = 'http://www.ipv6t.online:90/input.php'#更新在服务器端，本机IPV6地址
            guistatus, datajson =send_post_request(phptype, ipv6, id, port, url,sign,MAC)
            print('更新服务器后台返回数据：',guistatus, datajson)
            print('状态:',datajson['response'])



if __name__ == "__main__":
    main()

